<?php $__env->startSection('content'); ?>
<section>
	<div class="card elevation-0 mb-0">
		<div class="card-body p-0">
			<div class="row">
				<div class="col-12">
					<div class="table-responsive">
						<table class="table table-bordered table-striped mb-0">
							<thead>
								<tr>
									<th class="nowrap"><?php echo e(__('reports.th_name')); ?></th>
									<th><?php echo e(__('reports.th_amount')); ?></th>
									<th><?php echo e(__('reports.th_payment_date')); ?></th>
									<th class="nowrap"><?php echo e(__('reports.th_transaction_type')); ?></th>
									<th class="nowrap"><?php echo e(__('reports.th_payment_method')); ?></th>
									<th class="fixed-width-td"><?php echo e(__('reports.th_details')); ?></th>

								</tr>
							</thead>
							<tbody>
								<?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr>
									<td class="align-middle nowrap"><?php echo e(transaction_name($payment)); ?></td>
									<td class="align-middle"><?php echo transaction_type($payment); ?></td>
									<td class="align-middle nowrap"><?php echo e(format_date($payment->date)); ?></td>
									<td class="align-middle nowrap"><?php echo e($payment->type); ?></td>
									<td class="align-middle nowrap"><?php echo e($payment->method); ?></td>
									<td class="align-middle nowrap"><?php echo e($payment->note); ?></td>
								</tr>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

								<?php if(count($payments) == 0): ?>
								<tr>
									<td colspan="11">
										<p class="text-center text-muted mb-0">No Record Found</p>
									</td>
								</tr>
								<?php endif; ?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
	window.addEventListener("load", window.print());
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.invoice', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/views/reports/print/payment_transaction.blade.php ENDPATH**/ ?>